#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include <errno.h>
#include "exerr.h"


#define MAX_SLEEP_TIME 2

/* if enabled, then release owned mutex when failing to lock second one */
#define BACKOFF 0

pthread_mutex_t mutex1 = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t mutex2 = PTHREAD_MUTEX_INITIALIZER;

/* first locks mutex1 and then mutex2 -> reverse order than other thread */
void *
thread1 (void *arg)
{
  int r;

  while (1)
    {
      sleep (rand () % MAX_SLEEP_TIME);

      printf ("Thread 1 locks mutex1...\n");
      fflush (stdout);
      r = pthread_mutex_lock (&mutex1);
      COND_MSG_ABORT (r, r, "Mutex1 lock");
      printf ("Thread 1 acquired mutex1!\n");
      fflush (stdout);

      sleep (rand () % MAX_SLEEP_TIME);

      printf ("Thread 1 locks mutex2...\n");
      fflush (stdout);

#if !BACKOFF
      r = pthread_mutex_lock (&mutex2);
      COND_MSG_ABORT (r, r, "Mutex2 lock");
      printf ("Thread 1 acquired mutex2!\n");
      fflush (stdout);
#else
      r = pthread_mutex_trylock (&mutex2);
      if (r == EBUSY)
	{
	  printf ("Thread 1 failed to lock mutex2, releases mutex1\n");
	  r = pthread_mutex_unlock (&mutex1);
	  COND_MSG_ABORT (r, r, "Mutex1 unlock");
	  continue;
	}
      else
	COND_MSG_ABORT (r, r, "Mutex2 trylock");
	
      printf ("Thread 1 acquired mutex2!\n");
      fflush (stdout);
#endif


      r = pthread_mutex_unlock (&mutex2);
      COND_MSG_ABORT (r, r, "Mutex2 unlock");
      r = pthread_mutex_unlock (&mutex1);
      COND_MSG_ABORT (r, r, "Mutex1 unlock");
    }
}

/* first locks mutex2 and then mutex1 -> reverse order than other thread */
void *
thread2 (void *arg)
{
  int r;

  while (1)
    {
      sleep (rand () % MAX_SLEEP_TIME);

      printf ("Thread 2 locks mutex2...\n");
      fflush (stdout);
      r = pthread_mutex_lock (&mutex2);
      COND_MSG_ABORT (r, r, "Mutex2 lock");
      printf ("Thread 2 acquired mutex2!\n");
      fflush (stdout);

      sleep (rand () % MAX_SLEEP_TIME);

      printf ("Thread 2 locks mutex1...\n");
      fflush (stdout);

#if !BACKOFF
      r = pthread_mutex_lock (&mutex1);
      COND_MSG_ABORT (r, r, "Mutex1 lock");
      printf ("Thread 2 acquired mutex1!\n");
      fflush (stdout);
#else
      r = pthread_mutex_trylock (&mutex1);
      if (r == EBUSY)
	{
	  printf ("Thread 2 failed to lock mutex1, releases mutex2\n");
	  r = pthread_mutex_unlock (&mutex2);
	  COND_MSG_ABORT (r, r, "Mutex2 unlock");
	  continue;
	}
      else
	COND_MSG_ABORT (r, r, "Mutex1 trylock");

      printf ("Thread 2 acquired mutex1!\n");
      fflush (stdout);
#endif

      r = pthread_mutex_unlock (&mutex1);
      COND_MSG_ABORT (r, r, "Mutex1 unlock");
      r = pthread_mutex_unlock (&mutex2);
      COND_MSG_ABORT (r, r, "Mutex2 unlock");
    }
}

int
main (int argc, char **argv)
{
  srand (time (NULL));
  pthread_t thread;
  int r;

  r = pthread_create (&thread, NULL, thread1, NULL);
  COND_MSG_ABORT (r, r, "Thread creation");
  r = pthread_create (&thread, NULL, thread2, NULL);
  COND_MSG_ABORT (r, r, "Thread creation");

  pthread_exit (NULL);
}
