#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include "exerr.h"

#define NUM_THREADS 10

void *
print_hello_world (void *arg)
{
  sleep (3);
  /* Delay by 'sleep()' gives main-thread chance to terminate before
     dereferencing pointer into main-thread's stack. */
  int int_id = *((int *) arg);
  /* Expecting garbage value because pointer 'arg' likely to be
     dangling. */
  printf ("Hello world from thread %d\n", int_id);
  return NULL;
}

int
main (int argc, char **argv)
{
  /* Problematic: pointers into main-thread's 
     stack passed on to created threads. */
  int i, r, int_ids[NUM_THREADS];
  pthread_t thread;

  for (i = 0; i < NUM_THREADS; i++)
    {
      int_ids[i] = i;
      printf ("Creating thread %d\n", i);
      r = pthread_create (&thread, NULL, print_hello_world, &int_ids[i]);
      COND_MSG_ABORT (r, r, "Thread creation");
    }
  /* main-thread will terminate, created threads stay alive. Probably
     main-thread's stack is released, but created threads still have
     pointers into that stack. */
  pthread_exit (NULL);
}
