#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <assert.h>
#include <pthread.h>
#include "exerr.h"
#include "simple-barrier.h"

/* Note: only trivial error checking. */

int 
simple_barrier_init (SimpleBarrier * sb, unsigned int cnt)
{
  int r;
  sb->flag = 0;
  sb->cnt = sb->init_cnt = cnt;
  if ((r = pthread_mutex_init (&(sb->mutex), NULL)))
    return r;
  if ((r = pthread_cond_init (&(sb->cond), NULL)))
    return r;
  return 0;
}


int 
simple_barrier_destroy (SimpleBarrier * sb)
{
  int r;
  if ((r = pthread_mutex_lock (&(sb->mutex))))
      return r;
  if (sb->cnt != sb->init_cnt)
    {
      /* There are some threads waiting, cannot destroy barrier. */
      if ((r = pthread_mutex_unlock (&(sb->mutex))))
	return r;
      return 1;
    }

  if ((r = pthread_mutex_unlock (&(sb->mutex))))
      return r;

  sb->flag = sb->cnt = sb->init_cnt = 0;
  if ((r = pthread_mutex_destroy (&(sb->mutex))))
    return r;
  if ((r = pthread_cond_destroy (&(sb->cond))))
    return r;
  return 0;
}



int 
simple_barrier_wait (SimpleBarrier * sb)
{
  int r = 0;
  if ((r = pthread_mutex_lock (&(sb->mutex))))
      return r;
  unsigned int flag = sb->flag;
  assert (sb->cnt > 0);
  sb->cnt--;
  if (sb->cnt == 0)
    {
      printf ("cnt == 0, all arrived.\n");
      sb->cnt = sb->init_cnt;
      sb->flag = !sb->flag;
      if ((r = pthread_cond_broadcast (&(sb->cond))))
	return r;
      r = PTHREAD_BARRIER_SERIAL_THREAD;
    }
  else
    {
      /* NOTE: it is not possible to wait while 'sb->cnt != 0' because
	 the counter value has to be reset to initial value if 
	 'sb->cnt == 0'. */
      while (flag == sb->flag)
	{
	  if ((r = pthread_cond_wait (&(sb->cond), &(sb->mutex))))
	    return r;
	}
    }
  if ((r = pthread_mutex_unlock (&(sb->mutex))))
    return r;
  return r;
}
