#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <string.h>
#include "exerr.h"

typedef struct Data
{
  int val;
} Data;

#define NUM_THREADS 10

/* Switch between two buggy versions */
#define POINTER_RETURN 1

static pthread_t threads[NUM_THREADS];

/* PROBLEMATIC CASE 1: returning pointers to local variables. Stack
   memory may be reclaimed after thread termination, so these value are
   invalid then. */
void *
pointer_return (void *arg)
{
  Data *data = (Data *) arg;
  int arg_val = data->val;
  free (data);

  int result = arg_val * 100;
  /* GCC normally can issue warning when returning pointer to 
     local variable, but obviously not for 'pthread_exit(...)' */
#if 1
  printf("Thread %d stores result %d at %p\n", arg_val, result, &result);
  pthread_exit (&result);
#else
  return (&result);
#endif
}

/* PROBLEMATIC CASE 2: detached threads can not be joined. */
void *
detached_return (void *arg)
{
  Data *data = (Data *) arg;
  int r, arg_val = data->val;
  free (data);

  /* Thread's resources can all be reclaimed at termination -> join will (should) fail */
  r = pthread_detach (pthread_self ());
  COND_MSG_ABORT (r, r, "Detaching thread");

  pthread_exit (NULL);
}

int
main (int argc, char **argv)
{
  int i, r;
  for (i = 0; i < NUM_THREADS; i++)
    {
      Data *data = (Data *) malloc (sizeof (Data));
      data->val = i;

      printf ("Creating thread %d\n", i);

#if !POINTER_RETURN
      r = pthread_create (&threads[i], NULL, detached_return, (void *) data);
#else
      r = pthread_create (&threads[i], NULL, pointer_return, (void *) data);
#endif
      COND_MSG_ABORT (r, r, "Thread creation");
    }

  void *returnval;
  for (i = 0; i < NUM_THREADS; i++)
    {
      printf ("Waiting for thread %d to join...\n", i);
      r = pthread_join (threads[i], &returnval);
      COND_MSG_ABORT (r, r, "Thread join");
#if !POINTER_RETURN
      /* expected: code unreachable since join should fail */
      printf ("Detached thread %d joined\n", i);
#else
      /* expected: garbage values */
      printf ("Dereferencing pointer %p from thread %d: %d\n", (int *) returnval, i,
	      *((int *) returnval));
#endif
    }

  pthread_exit (NULL);
}
