#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include "exerr.h"

#define NUM_THREADS 10

/* Set to 0 if you want to disable mutex synchronization, resulting in
   data races. */
static const int enable_mutex = 0;

static int sum = 0;
static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
static int ids[NUM_THREADS];

void *
sum_up (void *arg)
{
  int local_sum, id, r;
  id = *((int *) arg);

  if (enable_mutex)
    {
      /* Lock-call will block current thread until access is
	 granted. */
      r = pthread_mutex_lock (&mutex);
      COND_MSG_ABORT (r, r, "Mutex lock");
      /* Thread is now in critical region. */
    }

  /* Get local copy of 'sum', add some delay to enforce data races if
     mutexes are not used. */
  local_sum = sum;
  sleep (rand () % 2);
  printf ("Thread %d adds its ID to sum\n", id);
  fflush (stdout);
  /* Write back result. */
  sum = local_sum + id;

  if (enable_mutex)
    {
      r = pthread_mutex_unlock (&mutex);
      COND_MSG_ABORT (r, r, "Mutex unlock");
    }

  pthread_exit (NULL);
}

int
main ()
{
  int i, r;
  void *rptr;
  pthread_t threads[NUM_THREADS];
  srand (time (NULL));

  for (i = 0; i < NUM_THREADS; i++)
    {
      ids[i] = i;
      r = pthread_create (&threads[i], NULL, sum_up, &ids[i]);
      COND_MSG_ABORT (r, r, "Thread creation");
    }
  for (i = 0; i < NUM_THREADS; i++)
    {
      r = pthread_join (threads[i], &rptr);
      COND_MSG_ABORT (r, r, "Thread join");
    }
  
  printf ("Sum: %d, expected: %d\n", sum, (NUM_THREADS - 1) * (NUM_THREADS) / 2);
  pthread_exit(NULL);
}
