#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#define NUM_THREADS 10

static int int_ids[NUM_THREADS];

void *
print_hello_world (void *arg)
{
  int int_id = *((int *) arg);
  sleep (3);
  printf ("Hello world from thread %d\n", int_id);
  return NULL;
}

int
main (int argc, char **argv)
{
  int i, r;
  pthread_t thread;
  for (i = 0; i < NUM_THREADS; i++)
    {
      int_ids[i] = i;
      printf ("Creating thread %d\n", i);
      r = pthread_create (&thread, NULL, print_hello_world, &int_ids[i]);
      if (r)
        {
          printf ("ERROR\n");
          exit (-1);
        }
    }
  /* main-thread will terminate, causing all 
     created threads to terminate as well */
  return 0;
}
