#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include "exerr.h"

#define NUM_THREADS 10

/* For convenience,  assign integer IDs to threads. */
static int int_ids[NUM_THREADS];

#define ABORT 0

void *
print_hello_world (void *arg)
{
  /* Read ID pointed to by pointer 'arg'. */
  int int_id = *((int *) arg);
  sleep (1);
  printf ("Hello world from thread %d\n", int_id);
  return NULL;
}

int
main (int argc, char **argv)
{
  int i, r;
  pthread_t thread;
  for (i = 0; i < NUM_THREADS; i++)
    {
      /* Assign integer ID to created thread. Pointer to that data
	 will be passed as argument to thread's function. */
      int_ids[i] = i;
      printf ("Creating thread %d\n", i);
      r = pthread_create (&thread, NULL, print_hello_world, &int_ids[i]);
      COND_MSG_ABORT (r, r, "Thread creation");
    }

#if !ABORT
  /* main thread will terminate, but created threads stay alive. */
  pthread_exit (NULL);
#else
  /* main-thread will terminate, causing the process  
     and all created threads to terminate as well */
  return 0;
#endif
}
