#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <time.h>
#include <assert.h>
#include <limits.h>
#include "exerr.h" 

/* We want to compute the sum over all elements of an integer array
   using PThreads. This can be done without any synchronization if every
   thread is assigned a separate slice of the array. */

#define NUM_THREADS 2
#define ARRAY_LENGTH (1 << 10)
#define MAX_VALUE 10

typedef struct Data
{
  int id;
  int from;
  int to;
} Data;

typedef struct Result
{
  int id;
  int val;
} Result;

static pthread_t threads[NUM_THREADS];
static int array[ARRAY_LENGTH];

/* threads operate on disjoint slices of data */
void *
thread_sum (void *arg)
{
  /* 'Data' object used for passing values to thread's function. */
  Data *d = (Data *) arg;
  int id = d->id;
  int from = d->from;
  int to = d->to;
  free (d);

  printf ("Thread %d: from %d to %d\n", id, from, to);
  fflush (stdout);

  int *p, *end = array + to, sum = 0;
  for (p = array + from; p < end; p++)
    sum += *p;

  /* 'Result' object used for returning values from thread's function. */
  Result *res = (Result *) malloc (sizeof (Result));
  res->id = id;
  res->val = sum;

  return (void *) res;
}

int
main (int argc, char **argv)
{
  srand (time (NULL));

  printf ("Initializing array of size %u...", ARRAY_LENGTH);
  fflush (stdout);

  int *ip, *end = array + ARRAY_LENGTH;
  for (ip = array; ip < end; ip++)
    {
      int randval = (rand () % MAX_VALUE);
      *ip = randval;
    }
  printf ("done\n");
  fflush (stdout);

  /* Partition array into non-overlapping slices. Threads can then
     operate independently from each other. */
  Data *data;
  int i, r, from = 0, to, slice_length = to = ARRAY_LENGTH / NUM_THREADS;
  for (i = 0; i < NUM_THREADS - 1; i++)
    {
      data = (Data *) malloc (sizeof (Data));
      data->id = i;
      data->from = from;
      data->to = to;

      from = to;
      to += slice_length;

      printf ("Creating thread %d\n", i);
      fflush (stdout);
      r = pthread_create (&threads[i], NULL, thread_sum, data);
      COND_MSG_ABORT (r, r, "Thread creation");
    }
  /* last slice possibly smaller */
  data = (Data *) malloc (sizeof (Data));
  data->id = NUM_THREADS - 1;
  data->from = from;
  data->to = ARRAY_LENGTH;

  printf ("Creating thread %d\n", i);
  fflush (stdout);
  r = pthread_create (&threads[i], NULL, thread_sum, data);
  COND_MSG_ABORT (r, r, "Thread creation");

  /* wait for threads to terminate */
  Result *thread_res;
  int thread_sum, sum = 0;
  for (i = 0; i < NUM_THREADS; i++)
    {
      printf ("Joining thread %d\n", i);
      r = pthread_join (threads[i], (void **) &thread_res);
      COND_MSG_ABORT (r, r, "Thread join");
      assert (thread_res->id == i);
      thread_sum = thread_res->val;
      free (thread_res);
      sum += thread_sum;
    }

  printf ("ARRAY SUM IS %d\n", sum);

  pthread_exit (NULL);
}
