#include <stdio.h>
#include <stdlib.h>

#include <sys/time.h>

static int fib (int n) {
  if (n < 2) return n;
  int x = fib (n - 1);
  int y = fib (n - 2);
  int r = x + y;
  return r;
}

double wall_clock_time () {
  double res = 0;
  struct timeval tv;
  if (!gettimeofday (&tv, 0))
  res = 1e-6 * tv.tv_usec, res += tv.tv_sec;
  return res;
}

int main (int argc, char ** argv) {
  int n = argc > 1 ? atoi (argv[1]) : 10;
  double s = wall_clock_time ();
  int f = fib (n);
  double t = wall_clock_time () - s;
  printf ("fib (%d) = %d in %.2f seconds\n", n, f, t);
  return 0;
}
