#include <cudaul/timer.h>
#include <cuda_runtime_api.h>
#include <iostream>

namespace cudaul {
	cudatimer::cudatimer(const std::string& name): name(name){
	cudaEventCreate(&starte);
	cudaEventCreate(&stope);
}

cudatimer::~cudatimer() {
	cudaEventDestroy(starte);
	cudaEventDestroy(stope);
}

void cudatimer::start() {
	cudaEventRecord(starte,0);
}

void cudatimer::stop() {
	cudaEventRecord(stope,0);
	cudaEventSynchronize(stope);
	float lastValueMS;
	cudaEventElapsedTime(&lastValueMS, starte, stope);
	
	std::cout << name << ": " << lastValueMS << " ms" << std::endl;
}
}
