macro(IncludeUserSettings)
	if(EXISTS ${CMAKE_SOURCE_DIR}/user.cmake)
		message(STATUS "including user settings user.cmake")
		include(${CMAKE_SOURCE_DIR}/user.cmake)
	else()
		message(AUTHOR_WARNING "can't find user.cmake")
	endif()
	if(WIN32)
		string(TOLOWER "$ENV{COMPUTERNAME}" COMPUTERNAME)
	else()
		find_program(HOSTNAME_BIN NAMES hostname)
		exec_program(${HOSTNAME_BIN} ARGS OUTPUT_VARIABLE HOSTNAME)
		string(TOLOWER "${HOSTNAME}" COMPUTERNAME)
	endif()
	if(EXISTS ${CMAKE_SOURCE_DIR}/user.${COMPUTERNAME}.cmake)
		message(STATUS "including user settings user.${COMPUTERNAME}.cmake")
		include(${CMAKE_SOURCE_DIR}/user.${COMPUTERNAME}.cmake)
	else()
		message(AUTHOR_WARNING "can't find user.${COMPUTERNAME}.cmake")
	endif()
endmacro(IncludeUserSettings)