function(target_use_package Libname)
	if(NOT TARGET ${CURRENT_NAME})
		message(ERROR "invalid target: ${CURRENT_NAME}")
		return()
	endif()
	message(STATUS "using library ${Libname} in target ${CURRENT_NAME}")

	foreach(arg ${ARGN})
		set(${arg} ON)
	endforeach()

	if(DEFINED ${Libname}_LIBRARIES AND NOT SKIP_LIBRARY_DIRS)
		target_link_libraries(${CURRENT_NAME} ${${Libname}_LIBRARIES})
		set(CURRENT_LIBRARIES ${CURRENT_LIBRARIES} ${${Libname}_LIBRARIES} PARENT_SCOPE)
	endif()
	if(TARGET ${${Libname}_NAME})
		#message(STATUS "add_dependencies ${${Libname}_NAME}")
		add_dependencies(${CURRENT_NAME} ${${Libname}_NAME})
	endif()
endfunction(target_use_package)

#must be before the target creation to be able to specify link_directories and add_definitions
function(use_package Libname)
	if(TARGET ${CURRENT_NAME})
		message(ERROR "use_package must be called before the target creation of: ${CURRENT_NAME} -> use target_use_package")
		return()
	endif()
	message(STATUS "using library ${Libname}")

	foreach(arg ${ARGN})
		set(${arg} ON)
	endforeach()

	if(DEFINED ${Libname}_DEFINITIONS AND NOT SKIP_DEFINITIONS)
		#message(STATUS "add_definitions ${${Libname}_DEFINITIONS}")
		#set_property(DIRECTORY APPEND COMPILE_DEFINITIONS ${${Libname}_DEFINITIONS})
		add_definitions(${${Libname}_DEFINITIONS})
		set(CURRENT_DEFINITIONS ${CURRENT_DEFINITIONS} ${${Libname}_DEFINITIONS} PARENT_SCOPE)
	endif()
	if(NOT SKIP_INCLUDE_DIRS)
		include_directories(${${Libname}_INCLUDE_DIRS})
		set(CURRENT_INCLUDE_DIRS ${CURRENT_INCLUDE_DIRS} ${${Libname}_INCLUDE_DIRS} PARENT_SCOPE)
	endif()
	if(DEFINED ${Libname}_LIBRARY_DIRS AND NOT SKIP_LIBRARY_DIRS)
		#message(STATUS "link_directories(${${Libname}_LIBRARY_DIRS})")
		link_directories(${${Libname}_LIBRARY_DIRS})
		set(CURRENT_LIBRARY_DIRS ${CURRENT_LIBRARY_DIRS} ${${Libname}_LIBRARY_DIRS} PARENT_SCOPE)
	endif()
	if(NOT SKIP_BIN_DIRS)
		set(CURRENT_BIN_DIRS ${CURRENT_BIN_DIRS} ${${Libname}_BIN_DIRS} PARENT_SCOPE)
	endif()
endfunction(use_package)