#ifndef CUDA_ERROR_H
#define CUDA_ERROR_H

#include <utils/log.h>

#include <cuda_runtime.h>

#define LOG_CUDA_ERRORS() \
	do{ \
		cudaError_t err = cudaGetLastError(); \
		if( cudaSuccess != err) { \
			LOG_ERROR << "CUDA ERROR: " << cudaGetErrorString(err); \
			\
		} \
	} while(0)

#endif
