@echo off
@setlocal
cd "%~dp0"

rem where is your cmake install, leave empty if its already in the path
set CMAKE_HOME=
rem which cmake generator do you want to use?
rem set CMAKE_GENERATOR=Visual Studio 9 2008
rem set CMAKE_GENERATOR=Visual Studio 12
rem Visual Studio 14 2015
rem Visual Studio 15 2017
rem Visual Studio 16 2019
set CMAKE_GENERATOR=Visual Studio 15
set CMAKE_PROPERTIES=-DENABLE_lab7c=ON
set CMAKE_GENERATOR_PLATFORM=x64


rem enhance the path with cmake
set PATH=%PATH%;%CMAKE_HOME%\bin

rem retrieving directory name for the solution file name
for %%A in ("%~dp0.") do (
	set SOLUTION_NAME=%%~nA
)
echo Directory Name: %SOLUTION_NAME%

rem create build dir and delete existing content
if exist build (
	rmdir /s build
)
mkdir build
cd build

rem start cmake
echo STARTING CMAKE
cmake -Wno-dev -G "%CMAKE_GENERATOR%" -A "%CMAKE_GENERATOR_PLATFORM%" %CMAKE_PROPERTIES% "../"
if %ERRORLEVEL%==0 (
	echo Setting Startup Project
	start ../slnStartupConfigurator.exe %SOLUTION_NAME%.sln ../cgexercises.xml
	echo Start solution
	start %SOLUTION_NAME%.sln
) else (
	echo CMake ist not correctly configured, edit this bat file and specify the correct settings or directly use cmake-gui
	pause
)