function(publish_package)
	message(STATUS "caching internal library ${CURRENT_NAME}")
	set(${CURRENT_NAME}_NAME ${CURRENT_NAME} CACHE STRING "library name" FORCE)
	set(${CURRENT_NAME}_INCLUDE_DIRS ${CURRENT_INCLUDE_DIRS} CACHE PATH "library include dirs" FORCE)
	set(${CURRENT_NAME}_DEFINITIONS ${CURRENT_DEFINITIONS} CACHE PATH "compile definitions" FORCE)
	if(CURRENT_BIN_DIRS)
		list(REMOVE_DUPLICATES CURRENT_BIN_DIRS)
	else()
		set(CURRENT_BIN_DIRS )
	endif()

	set(${CURRENT_NAME}_BIN_DIRS ${CURRENT_BIN_DIRS} CACHE PATH "library binary dirs" FORCE)

	#set(${CURRENT_NAME}_LIBRARIES
	#	debug ${CURRENT_NAME}${CMAKE_DEBUG_POSTFIX}
	#	optimized ${CURRENT_NAME}${CMAKE_RELEASE_POSTFIX}
	#	${CURRENT_LIBRARIES} CACHE STRING "library libraries" FORCE)
	set(${CURRENT_NAME}_LIBRARIES ${CURRENT_NAME} ${CURRENT_LIBRARIES} CACHE STRING "library libraries" FORCE)
	#	debug ${CURRENT_NAME}${CMAKE_DEBUG_POSTFIX}
	#	optimized ${CURRENT_NAME}${CMAKE_RELEASE_POSTFIX}
	#	${CURRENT_LIBRARIES} CACHE STRING "library libraries" FORCE)
	set(${CURRENT_NAME}_LIBRARY_DIRS
		${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
		${CURRENT_LIBRARY_DIRS} CACHE STRING "library directories" FORCE)

	mark_as_advanced(
		${CURRENT_NAME}_NAME
		${CURRENT_NAME}_INCLUDE_DIRS
		${CURRENT_NAME}_DEFINITIONS
		${CURRENT_NAME}_BIN_DIRS
		${CURRENT_NAME}_LIBRARIES
		${CURRENT_NAME}_LIBRARY_DIRS)


	#install package
	if(MSVC_IDE)
		install(TARGETS ${CURRENT_NAME}
			RUNTIME DESTINATION bin
			LIBRARY DESTINATION bin
			ARCHIVE DESTINATION lib)
	else()
		install(TARGETS ${CURRENT_NAME}
			RUNTIME DESTINATION bin
			LIBRARY DESTINATION lib
			ARCHIVE DESTINATION lib)
	endif()

	set(CURRENT_INSTALL_INCLUDE_PREFIX ${PROJECT_INSTALL_INCLUDE_PREFIX}${CURRENT_NAME})
	install(DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/ DESTINATION include/${CURRENT_INSTALL_INCLUDE_PREFIX}
		FILES_MATCHING PATTERN "*.h" PATTERN "*.inl"
		PATTERN ".svn" EXCLUDE)
endfunction(publish_package)

