#!/bin/sh
debug=no
logging=no
die () {
  echo "configure: error: $*" 1>&2
  exit 1
}
usage () {
cat <<EOF
usage: configure.sh [-h|--help] [-g|--debug] [-l|--logging]
EOF
}
while [ $# -gt 0 ]
do
  case "$1" in
    -h|--help) usage; exit 0;;
    -g|--debug) debug=yes;;
    -l|--logging) logging=yes;;
    *) die "invalid option '$1' (try '-h')";;
  esac
  shift
done
COMPILE="gcc -W -Wall -ggdb3"
[ $debug = no ] && COMPILE="$COMPILE -O3 -DNDEBUG"
[ $logging = yes ] && COMPILE="$COMPILE -DLOGGING"
echo "$COMPILE"
sed -e "s,@COMPILE@,$COMPILE," makefile.in > makefile
