#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <assert.h>
#include <pthread.h>
#include "exerr.h"

#define GET_RAND_VALUE(max) (rand() % (max))

#define ARRAY_SIZE (1 << 4)
#define NUM_THREADS (1 << 3)
#define THREAD_ROUNDS (1)
#define THREAD_WORKTIME (2)
static int seed = 0;
/* Threads will access one element of 'array' and simulate some work. */
static unsigned int array[ARRAY_SIZE] = { 0 };
static pthread_t thread_ids[NUM_THREADS];
/* One mutex locks entire array. */
static pthread_mutex_t big_mutex = PTHREAD_MUTEX_INITIALIZER;


static void *
thread_func (void *arg)
{
  unsigned long int uint_id = (unsigned long int) arg;
  unsigned int i, rounds;
  int r;
  rounds = THREAD_ROUNDS;
  for (i = 0; i < rounds; i++)
    {
      /* Pick position to be accessed at random. */
      unsigned int pos = GET_RAND_VALUE (ARRAY_SIZE);
      /* 'worktime' simulates some expensive work by putting thread to sleep. */
      unsigned int worktime = THREAD_WORKTIME;
      /* Thread locks ENTIRE array which prevents any other thread
         from access. This is bad because multiple thread could access
         different positions in the array without interfering. This
         results in a SERIAL execution of threads! */
      r = pthread_mutex_lock (&big_mutex);
      COND_MSG_ABORT (r, r, "Mutex lock");
      fprintf (stderr, "Thread %lu writes pos %u and works for %u seconds.\n",
	       uint_id, pos, worktime);
      /*Do some work. */
      array[pos]++;
      sleep (worktime);
      fprintf (stderr, "\tThread %lu releases lock of pos %u.\n", uint_id,
	       pos);
      r = pthread_mutex_unlock (&big_mutex);
      COND_MSG_ABORT (r, r, "Mutex unlock");
    }
  pthread_exit (NULL);
}


int
main ()
{
  int r;
  unsigned long int i;

  srand (seed);

  /* Create 'NUM_THREADS' threads which access positions of array randomly. */
  for (i = 0; i < NUM_THREADS; i++)
    {
      r = pthread_create (thread_ids + i, NULL, thread_func, (void *) i);
      COND_MSG_ABORT (r, r, "Thread creation");
    }

  /* Wait for threads to finish. */
  for (i = 0; i < NUM_THREADS; i++)
    {
      r = pthread_join (*(thread_ids + i), NULL);
      COND_MSG_ABORT (r, r, "Thread join");
    }

  pthread_exit (NULL);
}
