#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include "exerr.h"

#define NUM_THREADS 10

/* For convenience, assign integer IDs to threads. */
static int int_ids[NUM_THREADS];
/* Must store 'pthread_t' values of created threads to be used for
   joining. */
static pthread_t threads[NUM_THREADS];

void *
print_hello_world (void *arg)
{
  int int_id = *((int *) arg);
  sleep (1);
  printf ("Hello world from thread %d\n", int_id);
  return NULL;
}

int
main (int argc, char **argv)
{
  int i, r;
  for (i = 0; i < NUM_THREADS; i++)
    {
      int_ids[i] = i;
      printf ("Creating thread %d\n", i);
      r = pthread_create (&threads[i], NULL, print_hello_world, &int_ids[i]);
      COND_MSG_ABORT (r, r, "Thread creation");
    }

  for (i = 0; i < NUM_THREADS; i++)
    {
      printf ("Waiting for thread %d to join...\n", i);
      /* Null-pointer as second argument: ignoring thread's return
	 value.
	 Call of join will return if thread with pthread_t
	 value 'threads[i]' terminates. */
      r = pthread_join (threads[i], NULL);	
      COND_MSG_ABORT (r, r, "Thread join");
      printf ("Thread %d joined\n", i);
    }
  pthread_exit (NULL);
}
