#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <assert.h>
#include "exerr.h"

#define NUM_THREADS 10
#define SLEEP_TIME 3 /* must be high enough to allow threads to terminate */

static pthread_t threads[NUM_THREADS];

typedef struct Data
{
  int val;
} Data;

typedef struct Result
{
  int id;
  int int_res;
} Result;


static Result *results[NUM_THREADS];


void *
heap_return (void *arg)
{
  int r;

  /* Thread detaches itself: all resources may be released after
     termination. */
  r = pthread_detach (pthread_self ());
  COND_MSG_ABORT(r, r, "Detaching thread");

  Data *data = (Data *) arg;
  int id = data->val;
  free (data);

  /* Thread stores return value on the heap, using a separate 'Result'
     object. */
  Result *res = (Result *) malloc (sizeof (Result));
  res->id = id;
  res->int_res = id * 100;

  results[id] = res;

  pthread_exit (NULL);
}


int
main (int argc, char **argv)
{
  int i, r;
  for (i = 0; i < NUM_THREADS; i++)
    {
      Data *data = (Data *) malloc (sizeof (Data));
      data->val = i;
      printf ("Creating thread %d\n", i);
      /* 'Data' object used to pass argument to thread's function. */
      r = pthread_create (&threads[i], NULL, heap_return, (void *) data);
      COND_MSG_ABORT(r, r, "Thread creation");
    }

  /* DIRTY (BUGGY) WORKAROUND: give threads some time to write result
     -> there is a clean solution using condition variables (see example
     'returnval_heapcond'). */
  sleep (SLEEP_TIME);

  Result *resp;
  for (i = 0; i < NUM_THREADS; i++)
    {
      resp = results[i];
      assert (i == results[i]->id);
      printf ("Thread %d returned %d\n", i, resp->int_res);
      free (results[i]);
    }

  pthread_exit (NULL);
}
