#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

/*------------------------------------------------------------------------*/

static inline unsigned long clock_cycle () {
  unsigned lo, hi;
  __asm__ __volatile__("rdtscp" : "=a"(lo), "=d"(hi));
  return  ((unsigned long) lo) | (((unsigned long) hi) << 32);
}

#if 1
#define LINEARIZATIONPOINT(ARGS...) do { } while (0)
#else
#define LINEARIZATIONPOINT(FMT, ARGS...) \
do { printf ("%lu %u " FMT "\n", clock_cycle (), t->id, ##ARGS); } while (0)
#endif

/*------------------------------------------------------------------------*/

typedef struct Thread Thread;
typedef struct Stack Stack;

struct Stack {
  unsigned data;
  Stack * next;
};

struct Thread {
  unsigned id;
  unsigned rng;
  pthread_t thread;
  int pushed;
  int popped;
};

/*------------------------------------------------------------------------*/

int N;
Thread thread[2];

Stack * stack;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

/*------------------------------------------------------------------------*/

unsigned next_random_number (unsigned * p) {
  return ((*p = *p * 1103515245u + 12345u) / 65536u) % 32768u;
}

int choose (unsigned * p) { return !(next_random_number (p) & 8); }

/*------------------------------------------------------------------------*/

static void push (Thread * t, unsigned data) {
  Stack * new_stack = malloc (sizeof (Stack));
  new_stack->data = data;
  pthread_mutex_lock (&mutex);
  new_stack->next = stack;
  stack = new_stack;
  pthread_mutex_unlock (&mutex);
  LINEARIZATIONPOINT ("push %8u", data);
  t->pushed++;
}

static int pop (Thread * t, unsigned * res) {
  pthread_mutex_lock (&mutex);
  Stack * old_stack = stack;
  if (!old_stack) {
    pthread_mutex_unlock (&mutex);
    LINEARIZATIONPOINT ("empty");
    return 0;
  }
  stack = old_stack->next;
  pthread_mutex_unlock (&mutex);
  unsigned data = old_stack->data;
  LINEARIZATIONPOINT ("pop  %8u", data);
  free (old_stack);
  t->popped++;
  *res = data;
  return 0;
}

/*------------------------------------------------------------------------*/

static void * run (void * p) {
  Thread * t = p;
  unsigned data;
  for (unsigned i = 0; i < N; i++)
    if (choose (&t->rng)) {
      // data = next_random_number (&t->rng);
      data = 10 * t->id * N + i;
      push (t, data);
    } else (void) pop (t, &data);
  return 0;
}

/*------------------------------------------------------------------------*/

static void start (Thread * t, int id, unsigned seed) {
  t->id = id;
  t->rng = seed;
  pthread_create (&t->thread, 0, run, t);
}

/*------------------------------------------------------------------------*/

int main (int argc, char ** argv) {
  assert (sizeof (unsigned long) == 8);
  assert (sizeof (void *) == 8);
  assert (sizeof (Stack) == 16);
  N = argc > 1 ? atoi (argv[1]) : 100;
  start (thread + 0, 0, 42);
  start (thread + 1, 1, 13);
  pthread_join (thread[0].thread, 0);
  pthread_join (thread[1].thread, 0);
  int popped = thread[0].popped + thread[1].popped;
  int pushed = thread[0].pushed + thread[1].pushed;
  for (Stack * p = stack, * next; p; p = next) {
    popped++;
    next = p->next;
    free (p);
  }
  if (popped != pushed) {
    fprintf (stderr, "*** pushed %d, popped %d\n", pushed, popped);
    abort ();
  }
  return 0;
}
