#!/bin/sh

runs=3
threads=8

cnfs=`ls ../examples/*.cnf.xz|sed -e 's,.*/,,' -e 's,.cnf.xz$,,'`

rm -f *.log

for cnf in $cnfs
do
  thread=1
  while [ $thread -le $threads ]
  do
    run=1
    while [ $run -le $runs ]
    do
      echo -n $cnf.$thread.$run
      log=$cnf.$thread.$run.log
      ../parfail $thread ../examples/$cnf.cnf.xz >$log
      awk '/wall clock time/{print "", $6}' $log
      run=`expr $run + 1`
    done
    thread=`expr $thread + 1`
  done
done
