#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <assert.h>
#include <pthread.h>
#include "exerr.h"


static int no_locking = 0;
static unsigned int cnt = 0;
#define NO_LOCKING 1
static unsigned int iterations = 100000000;
static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;


void *
thread_func (void *arg)
{
  unsigned int i;
  for (i = 0; i < iterations; i++)
    {
      /* Locking is not required here because there is only one thread
         which increments the value of 'cnt'. However, frequent
         (un)locking of mutexes decreases performance substantially,
         as pointed out in this program. */
      if (!no_locking)
	{
	  int r = pthread_mutex_lock (&mutex);
	  COND_MSG_ABORT (r, r, "mutex lock");
	  cnt++;
	  r = pthread_mutex_unlock (&mutex);
	  COND_MSG_ABORT (r, r, "mutex unlock");
	}
      else
	cnt++;
    }
  pthread_exit (NULL);
}


static int
isnumstr (char *str)
{
  if (!*str)
    return 0;
  char *p;
  for (p = str; *p; p++)
    {
      char c = *p;
      if (!isdigit (c))
	return 0;
    }
  return 1;
}


int
main (int argc, char **argv)
{
  int r;
  unsigned long int i;
  pthread_t thread_id;

  for (i = 1; i < (unsigned long int) argc; i++)
    {
      char *str = argv[i];
      if (strcmp (str, "--no-locking") == 0)
	{
	  no_locking = 1;
	}
      else if (str[0] == '-')
	COND_MSG_ABORT (1, 0, "unknown option");
      else
	{
	  COND_MSG_ABORT (!(isnumstr (str)), 0,
			  "Expecting non-negative integer");
	  iterations = atoi (str);
	}
    }

  r = pthread_create (&thread_id, NULL, thread_func, (void *) i);
  COND_MSG_ABORT (r, r, "Thread creation");

  r = pthread_join (thread_id, NULL);
  COND_MSG_ABORT (r, r, "Thread join");

  fprintf (stderr, "Final cnt: %u\n", cnt);
  pthread_exit (NULL);
}
