#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <assert.h>
#include <pthread.h>
#include "exerr.h"
#include "simple-barrier.h"


#define NUM_THREADS 10
static pthread_t thread_ids[NUM_THREADS];
static SimpleBarrier simple_barrier;


static void *
thread_func (void *arg)
{
  unsigned long int uint_id = (unsigned long int) arg;
  int r;
  while (1)
    {
      sleep (rand() % 7);
      fprintf (stderr, "Thread %lu waits at barrier.\n", uint_id);
      r = simple_barrier_wait (&(simple_barrier));
      COND_MSG_ABORT(r, r, "simple barrier wait");
      fprintf (stderr, "\tThread %lu returns from barrier.\n", uint_id);
    }
  pthread_exit (NULL);
}


int
main ()
{
  int r;
  unsigned long int i;
  srand(time(NULL));

  simple_barrier_init (&simple_barrier, NUM_THREADS);

  for (i = 0; i < NUM_THREADS; i++)
    {
      r = pthread_create (thread_ids + i, NULL, thread_func, (void *) i);
      COND_MSG_ABORT (r, r, "Thread creation");
    }

  for (i = 0; i < NUM_THREADS; i++)
    {
      r = pthread_join (*(thread_ids + i), NULL);
      COND_MSG_ABORT (r, r, "Thread join");
    }

  pthread_exit (NULL);
}
