#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include "exerr.h"

typedef struct Data
{
  int val;
} Data;

#define NUM_THREADS 10

static pthread_t threads[NUM_THREADS];

/* Thread's function can return a pointer explicitly or by passing it
   as argument to 'pthread_exit' (see function
   'exit_return'). Function 'pthread_join' will make that pointer
   available to the thread which called 'pthread_join'. */

void *
ordinary_return (void *arg)
{
  Data *data = (Data *) arg;
  int arg_val = data->val;
  printf ("Thread %d: ordinary return\n", arg_val);
  data->val = arg_val * 100;

  return (void *) data; /* 'pthread_exit(...)' is called implicitly here */
}

void *
exit_return (void *arg)
{
  Data *data = (Data *) arg;
  int arg_val = data->val;
  printf ("Thread %d: exit return\n", arg_val);
  data->val = arg_val * 100;

  pthread_exit ((void *) data);
}

int
main (int argc, char **argv)
{
  int i, r;
  for (i = 0; i < NUM_THREADS; i++)
    {
      void *(*startup) (void *) = i % 2 ? ordinary_return : exit_return;
      /* 'Data' object used to pass values to thread's
	 function. Thread will then modify 'Data' object and return
	 pointer to it as return value. */
      Data *data = (Data *) malloc (sizeof (Data));
      data->val = i;
      printf ("Creating thread %d\n", i);
      r = pthread_create (&threads[i], NULL, startup, (void *) data);
      COND_MSG_ABORT(r, r, "Thread creation");
    }

  void *returnval;
  for (i = 0; i < NUM_THREADS; i++)
    {
      printf ("Waiting for thread %d to join...\n", i);
      r = pthread_join (threads[i], &returnval);
      COND_MSG_ABORT (r, r, "Thread join");
      /* Pointer 'returnval' points to thread's return value, which is
	 a pointer to a 'Data' object. */
      printf ("Thread %d joined and returned %d\n", i,
	      ((Data *) returnval)->val);
      free (returnval);
    }

  pthread_exit (NULL);
}
