#include <pthread.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

/*------------------------------------------------------------------------*/

static inline unsigned long clock_cycle () {
  unsigned lo, hi;
  __asm__ __volatile__("rdtscp" : "=a"(lo), "=d"(hi));
  return  ((unsigned long) lo) | (((unsigned long) hi) << 32);
}

#if 1
#define LINEARIZATIONPOINT(ARGS...) do { } while (0)
#else
#define LINEARIZATIONPOINT(FMT, ARGS...) \
do { printf ("%lu %u " FMT "\n", clock_cycle (), t->id, ##ARGS); } while (0)
#endif

/*------------------------------------------------------------------------*/

typedef struct Thread Thread;
typedef struct Stack Stack;

struct Stack {
  unsigned data;
  Stack * next;
};

struct Thread {
  unsigned id;
  unsigned rng;
  pthread_t thread;
  int pushed;
  int popped;
};

/*------------------------------------------------------------------------*/

int N;
Thread thread[2];
Stack * stack;

/*------------------------------------------------------------------------*/

static unsigned next_random_number (unsigned * p) {
  return ((*p = *p * 1103515245u + 12345u) / 65536u) % 32768u;
}

static int choose (unsigned * p) { return !(next_random_number (p) & 8); }

/*------------------------------------------------------------------------*/

static unsigned short tag (void * p) { return ((unsigned long) p) >> 48; }

static void * ptr (void * p) {
  unsigned long w = (unsigned long) p;
  w &= ~0ul >> 16;
  w |= (w & (1ul << 47)) * (~0ul << 48);
  return (void*) w;
}

static void * tagged (void * p, unsigned short t) {
  unsigned long w = (unsigned long) p;
  w &= ~0ul >> 16;
  w |= ((unsigned long) t) << 48;
  void * res = (void *) w;
  assert (ptr (res) == p);
  assert (tag (res) == t);
  return res;
}

/*------------------------------------------------------------------------*/

static void push (Thread * t, unsigned data) {
  Stack * actual = malloc (sizeof (Stack));
#if 0
  unsigned short i = 0;
  do (void) tagged (actual, i); while (++i);
#endif
  actual->data = data;
  Stack * old_stack;
  Stack * new_stack;
  do {
    old_stack = stack;
    actual->next = ptr (old_stack);
    new_stack = tagged (actual, tag (old_stack) + 1);
  } while (!__sync_bool_compare_and_swap (&stack, old_stack, new_stack));
  LINEARIZATIONPOINT ("push %08x", data);
  t->pushed++;
}

static int pop (Thread * t, unsigned * res) {
  Stack * old_stack;
  Stack * new_stack;
  Stack * actual;
  do {
    old_stack = stack;
    actual = ptr (old_stack);
    if (!actual) {
      LINEARIZATIONPOINT ("empty");
      return 0;
    }
    new_stack = tagged (actual->next, tag (old_stack) + 1);
  } while (!__sync_bool_compare_and_swap (&stack, old_stack, new_stack));
  unsigned data = actual->data;
  free (actual);
  LINEARIZATIONPOINT ("pop  %08x", data);
  t->popped++;
  *res = data;
  return 0;
}

/*------------------------------------------------------------------------*/

static void * run (void * p) {
  Thread * t = p;
  unsigned data;
  for (int i = 0; i < N; i++)
    if (choose (&t->rng)) {
      // data = next_random_number (&t->rng);
      data = 10 * t->id * N + i;
      push (t, data);
    } else (void) pop (t, &data);
  return 0;
}

/*------------------------------------------------------------------------*/

static void start (Thread * t, int id, unsigned seed) {
  t->id = id;
  t->rng = seed;
  pthread_create (&t->thread, 0, run, t);
}

/*------------------------------------------------------------------------*/

int main (int argc, char ** argv) {
  assert (sizeof (unsigned long) == 8);
  assert (sizeof (void *) == 8);
  assert (sizeof (Stack) == 16);
  N = argc > 1 ? atoi (argv[1]) : 100;
  start (thread + 0, 0, 42);
  start (thread + 1, 1, 13);
  pthread_join (thread[0].thread, 0);
  pthread_join (thread[1].thread, 0);
  int popped = thread[0].popped + thread[1].popped;
  int pushed = thread[0].pushed + thread[1].pushed;
  for (Stack * p = ptr (stack), * next; p; p = next) {
    popped++;
    next = p->next;
    free (p);
  }
  if (popped != pushed) {
    fprintf (stderr, "*** pushed %d, popped %d\n", pushed, popped);
    abort ();
  }
  return 0;
}
