#include <pthread.h>
#include <stdio.h>

/*------------------------------------------------------------------------*/

// Do not print anything.
#define P(I) do { } while (0)

// Print all values.
// #define P(I) do { printf (#I " = %ld\n", I); } while (0)

/*------------------------------------------------------------------------*/

// Do not synchronize at all.
#define SYNC do { } while (0)

// Memory fence (flush caches) after each write and read.
// #define SYNC do { __sync_synchronize (); } while (0)

// Enforce maximal parallelism (sync after each read & write).
// #define SYNC do { pthread_barrier_wait (&barrier); } while (0)

pthread_barrier_t barrier;      // Only used in the last case.

/*------------------------------------------------------------------------*/

long a, b;

// long f () { a = 1; long tmp = a; return tmp + b; }

void * f (void * q) {
  a = 1;                // fwa1
SYNC;
  long c = a;           // frac
SYNC;
P(c);
  long d = b;           // frbd
SYNC;
P(d);
  long u = c + d;       // fadd
P(u);
  return (void*) u;
}

// long g () { b = 1; long tmp = b; return tmp + a; }

void * g (void * p) {
  b = 1;                // gwa1
SYNC;
  long e = b;           // grae
SYNC;
P(e);
  long f = a;           // grbf
SYNC;
P(f);
  long v = e + f;	// gadd
P(v);
  return (void*) v;
}

pthread_t s, t;

int main () {
  pthread_barrier_init (&barrier, 0, 2);
  pthread_create (&s, 0, f, 0);
  pthread_create (&t, 0, g, 0);
  long u, v;
  pthread_join (s, (void**) &u);
  pthread_join (t, (void**) &v);
  long m = u + v;
  printf ("%ld\n", m);  // madd
}

/*
sequential consistent
rare interleaved scenario with result 4:
(can be forced by barrier)

abcdefuvm
00------- fwa1
00------- fwa1 gwb1
00------- fwa1 gwb1 frac
00------- fwa1 gwb1 frac grbe
00------- fwa1 gwb1 frac grbe frbd
00------- fwa1 gwb1 frac grbe frbd graf
10------- gwb1 frac grbe frbd graf
11------- frac grbe frbd graf
111------ grbe frbd graf
111-1---- frbd graf
11111---- graf
111111--- fadd
111111--- fadd gadd
111111--- fadd gadd madd
1111112-- gadd madd
11111122- madd
111111224
*/

/*
sequential consistent
common non-interleaved scenario with result 3:

abcdefuvm
00------- fwa1
00------- fwa1 frac frbd
10------- frac frbd
101------ frbd
1010----- gwb1
1010----- gwb1 grbe
1010----- gwb1 grbe graf
1110----- grbe graf
11101---- graf
111011---
...
111011123
*/

/*
sequential inconsistent
less frequent scenario with result 2:
(with two out-of-order reads)

abcdefuvm
00------- fwa1
00------- fwa1 frac frbd
00------- fwa1 frbd             # frac out-of-order
001------ fwa1
0010----- fwa1 gwb1
0010----- fwa1 gwb1 grbe
0010----- fwa1 gwb1 grbe graf
00101---- fwa1 gwb1 graf        # grbe out-of-order
001010--- fwa1 gwb1
101010--- gwb1
111010---
...
111010112
*/

/*
sequential inconsistent
less frequent scenario with result 2:
(only one out-of-order read)

abcdefuvm
00------- fwa1
00------- fwa1 frac frbd
00------- fwa1 frbd             # frac out-of-order
001------ fwa1
0010----- fwa1 gwb1
0110----- fwa1
0110----- fwa1 grbe
01101---- fwa1 graf
011010--- fwa1
111010---
...
111010112
*/
